#include "General.h"
#include "BetterMSGConsoleCommand.h"
#include "CommandLineParser.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "engine_game.h"
#include "gmgame.h"
#include "Iterator.h"

bool DoStringPrepend = false;
StringClass PrependString, SoundFile;
unsigned int ColourRed, ColourGreen, ColourBlue;

void* HookupAT3x(void* a, void* b, void* c, void* patch_start, void* patch_end, int (*version_selector)())
{
	return HookupAT3(a,b,c,patch_start,patch_end,version_selector);
}

RENEGADE_FUNCTION
uint Send_Object_Update(NetworkObjectClass* object, int remoteHostId)
AT2(0x00461820,0x004612F0);

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);
	Console_Input(buffer);
}

int Find_Name_Change_Victim()
{
	int ReturnID = -1;
	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *p = PlayerIter->Data();
		if (p->IsActive && Get_GameObj(p->Get_Id()))
		{	
			ReturnID = p->Get_Id();
			break;
		}
	}
	return ReturnID;
}

void Set_Name(int PlayerID, WideStringClass Nick)
{
	Find_Player(PlayerID)->PlayerName = Nick;
	Find_Player(PlayerID)->Set_Object_Dirty_Bit(NetworkObjectClass::BIT_CREATION, true);

	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *p = PlayerIter->Data();
//		if (p->IsActive && Get_GameObj(p->Get_Id()))
//		{	
			Send_Object_Update(Find_Player(PlayerID), p->Get_Id());
//		}
	}	
}

void NewMSG(const char* Message)
{
	StringClass FormattedString;
	WideStringClass OriginalNick;
	int NameID = Find_Name_Change_Victim();

	if (NameID == -1) // If we can't find a nick change victim show a normal host message
	{
		Send_Client_Text(Message, TEXT_MESSAGE_PUBLIC, false, 0, -1, true, true);
		return;
	}

	OriginalNick = Find_Player(NameID)->PlayerName;
	Set_Name(NameID, WideStringClass(PrependString));

	if (DoStringPrepend)
	{
		FormattedString = StringClass::getFormattedString("%s: %s", PrependString, Message);
	}

	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *p = PlayerIter->Data();

		if (p->IsActive && Get_GameObj(p->Get_Id()))
		{	
			float Version = Get_Client_Version(p->Get_Id());

			if (Version < 2.9)
			{
				cScTextObj *TextObj = Send_Client_Text(Message, TEXT_MESSAGE_PUBLIC, false, NameID, -1, false, false);
				TextObj->Set_Object_Dirty_Bits(p->Get_Id(), NetworkObjectClass::BIT_CREATION);
				Send_Object_Update(TextObj, p->Get_Id());
			}
			else
			{
				Create_2D_WAV_Sound_Player(Get_GameObj(p->Get_Id()), SoundFile);
				
				if (DoStringPrepend)
				{
					Send_Message_Player(Get_GameObj(p->Get_Id()), ColourRed, ColourGreen, ColourBlue, FormattedString);
				}
				else
				{
					Send_Message_Player(Get_GameObj(p->Get_Id()), ColourRed, ColourGreen, ColourBlue, Message);
				}
			}
		}
	}

	if (NameID != -1)
	{
		Set_Name(NameID, OriginalNick);
	}
//	Console("msg ID = %d, Target = %d, Message = %S, Type = %d, IsPopup = %d", TextObj->ID, TextObj->Target, TextObj->Message, TextObj->Type, TextObj->IsPopup);
}

class CommandMESSAGE :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "message"; 
	}
	const char* Get_Alias()
	{
		return "msg";
	}
	const char* Get_Help() 
	{ 
		return "MESSAGE <message> - sends a chat message to all clients. Host only.";
	}
	void Activate(const char* argumentsString)
	{
		NewMSG(argumentsString);
	}
};

class BetterMSGConsoleCommand : public Plugin
{
public:
	BetterMSGConsoleCommand()
	{
		RegisterEvent(EVENT_GLOBAL_INI,this);

		const DynamicVectorClass<ConsoleFunctionClass*> consoleFunctions(ConsoleFunctionList);
		TT_FOREACH(consoleFunction, consoleFunctions)
		{
			const char* name = (*consoleFunction)->Get_Name();
			if (name)
			{
				if (strcmp(name, "message") == 0)
				{
					ConsoleFunctionList.DeleteObj((*consoleFunction));
//					OriginalMSG = (*consoleFunction);
				}
			}
		}
		ConsoleFunctionList.Add(new CommandMESSAGE);
		Sort_Function_List();
		Verbose_Help_File();
	}

	virtual void OnLoadGlobalINISettings(INIClass *SSGMIni)
	{
		DoStringPrepend = SSGMIni->Get_Bool("BetterMSGConsoleCommand", "DoStringPrepend", false);
		SSGMIni->Get_String(PrependString, "BetterMSGConsoleCommand", "PrependString", "");
		SSGMIni->Get_String(SoundFile, "BetterMSGConsoleCommand", "SoundFile", "");
		ColourRed = (unsigned int)SSGMIni->Get_Int("BetterMSGConsoleCommand", "ColourRed", 255);
		ColourGreen = (unsigned int)SSGMIni->Get_Int("BetterMSGConsoleCommand", "ColourGreen", 250);
		ColourBlue = (unsigned int)SSGMIni->Get_Int("BetterMSGConsoleCommand", "ColourBlue", 250);
	}

	~BetterMSGConsoleCommand()
	{
		UnregisterEvent(EVENT_GLOBAL_INI,this);

		const DynamicVectorClass<ConsoleFunctionClass*> consoleFunctions(ConsoleFunctionList);
		TT_FOREACH(consoleFunction, consoleFunctions)
		{
			const char* name = (*consoleFunction)->Get_Name();
			if (name)
			{ 
				if (strcmp(name, "message") == 0)
				{
					ConsoleFunctionList.Delete(consoleFunction);
				}
			}
		}
	}	
};

BetterMSGConsoleCommand betterMSGConsoleCommand;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &betterMSGConsoleCommand;
}